/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.flowable;

import dev.compactmods.crafting.lib.reactivestreams.Publisher;
import dev.compactmods.crafting.lib.reactivestreams.Subscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Action;
import dev.compactmods.crafting.lib.reactivex.rxjava3.functions.Consumer;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.functions.Functions;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.functions.ObjectHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscribers.BlockingSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscribers.BoundedSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscribers.LambdaSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.BlockingHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.BlockingIgnoringReceiver;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ExceptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.NotificationLite;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public final class FlowableBlockingSubscribe {
    private FlowableBlockingSubscribe() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void subscribe(Publisher<? extends T> source, Subscriber<? super T> subscriber) {
        LinkedBlockingQueue<Object> queue = new LinkedBlockingQueue<Object>();
        BlockingSubscriber bs = new BlockingSubscriber((Queue<Object>)queue);
        source.subscribe(bs);
        try {
            while (!bs.isCancelled()) {
                Object v = queue.poll();
                if (v == null) {
                    if (bs.isCancelled()) break;
                    BlockingHelper.verifyNonBlocking();
                    v = queue.take();
                }
                if (!bs.isCancelled() && v != BlockingSubscriber.TERMINATED && !NotificationLite.acceptFull(v, subscriber)) continue;
                break;
            }
        }
        catch (InterruptedException e) {
            bs.cancel();
            subscriber.onError(e);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> source) {
        BlockingIgnoringReceiver callback = new BlockingIgnoringReceiver();
        LambdaSubscriber ls = new LambdaSubscriber(Functions.emptyConsumer(), callback, callback, Functions.REQUEST_MAX);
        source.subscribe(ls);
        BlockingHelper.awaitForComplete(callback, ls);
        Throwable e = callback.error;
        if (e != null) {
            throw ExceptionHelper.wrapOrThrow(e);
        }
    }

    public static <T> void subscribe(Publisher<? extends T> o, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        FlowableBlockingSubscribe.subscribe(o, new LambdaSubscriber<T>(onNext, onError, onComplete, Functions.REQUEST_MAX));
    }

    public static <T> void subscribe(Publisher<? extends T> o, Consumer<? super T> onNext, Consumer<? super Throwable> onError, Action onComplete, int bufferSize) {
        Objects.requireNonNull(onNext, "onNext is null");
        Objects.requireNonNull(onError, "onError is null");
        Objects.requireNonNull(onComplete, "onComplete is null");
        ObjectHelper.verifyPositive(bufferSize, "number > 0 required");
        FlowableBlockingSubscribe.subscribe(o, new BoundedSubscriber<T>(onNext, onError, onComplete, Functions.boundedConsumer(bufferSize), bufferSize));
    }
}

